#!/bin/sh
##
# Shove.sh
# Package a set of files into a POSIX tar achive and compress the result
#
# Wilfredo Sanchez | wsanchez@opensource.apple.com
##

# EXTENSIONS : "*"
# OSTYPES    : "****"

tarfile="/tmp/ShoveIt_tmp-$$.tar"

for file; do
    member=$(basename "$file")
  location=$( dirname "$file")
  if [ -f "${tarfile}" ]; then flag="r"; else flag="c"; fi
  tar -C "${location}" -"${flag}" -f "${tarfile}" "${member}"
done

gzip -9 "${tarfile}"

mv "${tarfile}.gz" "$1.tgz"
